--[[---------------------------------------------------------------------------
	Chocolatier Two Ledger
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local pauseButtonFont = { standardFontName, kTwentyEight, DefaultColor }
local LedgerLabelFont = { standardFontName, kEighteen, DefaultColor }

local fullLedgerHeight = 310

local questText
if (gSim and gSim.quest) then
	questText = gSim.quest:SummaryText()
	if questText then questText = "#"..questText end
else
	questText = nil
end

local badgeButtons = {}
if not gDisableBadgeButtons then
--	local outline = "#<outline color='000000' size=2>"
	local outline = "#"

	badgeButtons =
	{
		Button { x=158,y=26, name="to_map", graphics={ "control/globe_up", "control/globe_down", "control/globe_over" },
			--scale=1.0,
			command = function() SwapToModal("ui/map.lua") end, },
		Text { x=158,y=21,w=68,h=52, label=outline..GetString("map"), name="to_map_label", flags=kHAlignCenter+kVAlignBottom, font=standardWhiteFont },
			
		Button { x=158,y=26, name="to_port", graphics={ "control/port_up", "control/port_down", "control/port_over" },
			--scale=1.0,
			command = function() SwapToModal("ui/portview.lua") end, },
		Text { x=158,y=21,w=68,h=52, label=outline..GetString("city"), name="to_port_label", flags=kHAlignCenter+kVAlignBottom, font=standardWhiteFont },

		Button { x=75,y=12, name="recipe", graphics={ "control/recipe_up", "control/recipe_down", "control/recipe_over" },
			--scale=1.0,
			command = function() DoModal("ui/recipebook.lua") end, },
		Text { x=75,y=8,w=91,h=52, label=outline..GetString("recipes"), flags=kHAlignCenter+kVAlignBottom, font=standardWhiteFont },
			
		Button { x=16,y=26, name="pause", graphics={ "control/pause_up", "control/pause_down", "control/pause_over" },
--			Text { x=0,y=30,w=56,h=30, label="pause", font=pauseButtonFont },
			--scale=1.0,
			command = function() DoModal("ui/pausedialog.lua") end, },
		Text { x=16+12,y=21,w=68-12,h=52, label=outline..GetString("pause"), flags=kHAlignCenter+kVAlignBottom, font=standardWhiteFont },
	}
end

return Ledger
{
	name="ledger",
--	x=ui.xOffset,y=ui.screenHeight+ui.yOffset-fullLedgerHeight,w=ui.screenWidth,h=fullLedgerHeight,
	x=ui.xOffset,y=ui.yOffset+ui.screenHeight-fullLedgerHeight,w=ui.screenWidth,h=fullLedgerHeight,
	
	data=gSim,
	showQuestY = 0,
	hideQuestY = 53,
	
	-- Quest text
	Bitmap { x=235,y=0, image="image/ledger_quest", name="quest",
		Rollover { x=44,y=62, w=497,h=39, contents="gSim:RolloverCurrentQuest()",
			Text { x=0,y=0,w=497,h=39, name="quest_text", label=questText, font=dialogFont },
		},
		},

	-- Ledger contents
--	Bitmap { x=218,y=0, image="image/ledger",
	Bitmap { x=258,y=fullLedgerHeight-210, image="image/ledger",
		Window {
			x=21,y=40,w=ui.ledgerWidth,h=ui.ledgerHeight, name="contents",
			DynamicWindow { name="messages", x=0,y=0,w=kMax,h=kMax, contents="ui/ledger_messages.lua", init=false },
			DynamicWindow { name="factories", x=0,y=0,w=kMax,h=kMax, contents="ui/ledger_factories.lua", init=false },
			DynamicWindow { name="inventory", x=0,y=0,w=kMax,h=kMax, contents="ui/ledger_inventory.lua", init=false },
		},

		-- Ledger selection buttons
		BeginGroup(),
		Button { x=1,y=3, type=kRadio, name="btn_messages",
			graphics = {"control/btn_messages_up","control/btn_messages_down","control/btn_messages_over","control/btn_messages_down"},
--			scale = .7,
			command = function() SetLedgerContents("messages") end,
		},
		Button { x=170,y=3, type=kRadio, name="btn_factories",
			graphics = {"control/btn_factory_up","control/btn_factory_down","control/btn_factory_over","control/btn_factory_down"},
--			scale = .7,
			command = function() SetLedgerContents("factories") end,
		},
		Button { x=396,y=3, type=kRadio, name="btn_inventory",
			graphics = {"control/btn_inventory_up","control/btn_inventory_down","control/btn_inventory_over","control/btn_inventory_down"},
--			scale = .7,
			command = function() SetLedgerContents("inventory") end,
		},

		Text { x=55,y=11,w=66,h=20, flags=kVAlignCenter+kHAlignCenter, font=LedgerLabelFont, label="lbl_messages" },
		Text { x=185,y=11,w=60,h=20, flags=kVAlignCenter+kHAlignCenter, font=LedgerLabelFont, label="lbl_factory" },
		Text { x=293,y=11,w=63,h=20, flags=kVAlignCenter+kHAlignCenter, font=LedgerLabelFont, label="lbl_status" },
		Text { x=407,y=11,w=75,h=20, flags=kVAlignCenter+kHAlignRight, font=LedgerLabelFont, label="lbl_inventory" },
	},

	-- Badge
	Bitmap { x=0,y=fullLedgerHeight-238, image="image/ledger_badge",
		Group(badgeButtons),
		DynamicWindow { name="badge", contents="ui/ledger_badge.lua" },
	},
}
